<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// الاتصال بقاعدة البيانات
$servername = "localhost";
$username = "u565109619_can47"; // اسم المستخدم الصحيح
$password = "Y8PwwD|fLI#i"; // كلمة المرور الصحيحة
$dbname = "u565109619_can47"; // اسم قاعدة البيانات الصحيحة

$conn = new mysqli($servername, $username, $password, $dbname);

// التحقق من الاتصال
if ($conn->connect_error) {
    die("⚠️ فشل الاتصال بقاعدة البيانات: " . $conn->connect_error);
}

// جلب أحدث معرف R_ID
$lastR = '';
$sql = "SELECT R_ID FROM transactions ORDER BY created_at DESC LIMIT 1";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $lastR = $row['R_ID'];
} else {
    $lastR = "لا يوجد معرف متاح";
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تحديث الحالة</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f4f4f9;
            font-family: Arial, sans-serif;
        }
        .header {
            display: flex;
            justify-content: center;
            align-items: center;
            margin-top: 20px;
            gap: 10px;
        }
        .header h1 {
            font-size: 2rem;
            color: #444;
        }
        .header i {
            font-size: 2.5rem;
            color: #28a745;
        }
        .form-control {
            margin-bottom: 20px;
        }
        .btn-custom {
            background-color: #28a745;
            color: #fff;
            font-weight: bold;
            border: none;
            border-radius: 5px;
            padding: 10px 20px;
            transition: background-color 0.3s ease-in-out;
        }
        .btn-custom:hover {
            background-color: #218838;
        }
        .nav-icons {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
        }
        .nav-icons a {
            color: #007bff;
            font-size: 1.5rem;
            text-decoration: none;
        }
        .nav-icons a:hover {
            color: #0056b3;
        }
        .message-box {
            display: none;
            text-align: center;
            margin-top: 15px;
            padding: 10px;
            font-size: 14px;
            font-weight: bold;
            border-radius: 5px;
        }
        .success {
            background-color: #28a745;
            color: white;
        }
        .error {
            background-color: #dc3545;
            color: white;
        }
    </style>
</head>
<body>
    <div class="container mt-5">
        <div class="header">
            <i class="fas fa-sync-alt"></i>
            <h1>تحديث الحالة</h1>
        </div>

        <!-- مربع الرسالة -->
        <div id="messageBox" class="message-box"></div>

        <form id="updateForm" class="mt-4">
            <label for="rNumber">معرف العملية:</label>
            <div class="input-group">
                <input type="text" id="rNumber" class="form-control" placeholder="أدخل معرف R" value="<?php echo $lastR; ?>" required>
                <button type="button" class="btn btn-primary copy-btn" onclick="copyText('rNumber')">نسخ</button>
            </div>

            <label for="status">الحالة:</label>
            <select id="status" class="form-control mb-3" required>
                <option value="C">الحالة</option>
                <option value="Completed">نجاح</option>
                <option value="Cancelled">فشل</option>
            </select>

            <button type="button" class="btn btn-custom w-100" onclick="updateStatus()">تحديث الحالة</button>
        </form>

        <div class="nav-icons">
            <a href="dashboard.html"><i class="fas fa-home"></i> الصفحة الرئيسية</a>
            <a href="creaate.html"><i class="fas fa-plus-circle"></i> إنشاء رابط دفع</a>
        </div>
    </div>

    <script>
    async function updateStatus() {
        const rNumber = document.getElementById("rNumber").value;
        const status = document.getElementById("status").value;
        const messageBox = document.getElementById("messageBox");

        if (!rNumber) {
            showMessage("يرجى إدخال معرف R.", "error");
            return;
        }

        try {
            const response = await fetch("updateStatus.php", {
                method: "POST",
                headers: { "Content-Type": "application/x-www-form-urlencoded" },
                body: `R_ID=${rNumber}&status=${status}`
            });
            const result = await response.json(); // معالجة الاستجابة كـ JSON
            if (result.success) {
                showMessage(result.message || "تم التحديث بنجاح", "success");
            } else {
                showMessage(result.message || "حدث خطأ أثناء التحديث", "error");
            }
        } catch (error) {
            console.error("Error updating status:", error);
            showMessage("حدث خطأ أثناء تحديث الحالة.", "error");
        }
    }

    function showMessage(message, type) {
        const messageBox = document.getElementById("messageBox");
        messageBox.innerText = message; // عرض الرسالة النصية مباشرة
        messageBox.className = `message-box ${type}`;
        messageBox.style.display = "block";

        // إخفاء الرسالة بعد 2 ثانية
        setTimeout(() => {
            messageBox.style.display = "none";
        }, 5000);
    }
</script>

</body>
</html>
