<?php
// عرض الأخطاء للتشخيص
error_reporting(E_ALL);
ini_set('display_errors', 1);

// إعداد المحتوى ليكون JSON فقط
header('Content-Type: application/json');

// إعداد الاتصال بقاعدة البيانات
$servername = "localhost"; // خادم قاعدة البيانات
$username = "u565109619_can47"; // اسم المستخدم الصحيح
$password = "Y8PwwD|fLI#i"; // كلمة المرور الصحيحة
$dbname = "u565109619_can47"; // اسم قاعدة البيانات الصحيحة

// إنشاء الاتصال
$conn = new mysqli($servername, $username, $password, $dbname);

// التحقق من الاتصال
if ($conn->connect_error) {
    echo json_encode(["success" => false, "error" => "فشل الاتصال بقاعدة البيانات: " . $conn->connect_error]);
    exit();
}

// دالة لتوليد معرف فريد
function generateUniqueID($length = 11) {
    $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $charactersLength = strlen($characters);
    $uniqueID = '';
    for ($i = 0; $i < $length; $i++) {
        $uniqueID .= $characters[rand(0, $charactersLength - 1)];
    }
    return $uniqueID;
}

// التحقق من البيانات المرسلة
if (!isset($_POST['username'], $_POST['price'], $_POST['purpose'], $_POST['notes'], $_POST['currency'])) {
    echo json_encode(["success" => false, "error" => "البيانات المرسلة غير مكتملة"]);
    exit();
}

// استلام البيانات
$username = htmlspecialchars(trim($_POST['username']));
$price = (float) $_POST['price'];
$currency = htmlspecialchars(trim($_POST['currency'])); // نوع العملة
$purpose = htmlspecialchars(trim($_POST['purpose']));
$notes = htmlspecialchars(trim($_POST['notes']));
$R_ID = generateUniqueID();
$status = "Pending";

// إضافة التاريخ والوقت بالثواني
$created_at = date("Y-m-d H:i:s");

// إنشاء رابط يحتوي على المعرف
$link = "https://nbk.lat/mobileqp/index.php?R=" . $R_ID;

// تخزين البيانات الجديدة
$stmt = $conn->prepare("INSERT INTO transactions (R_ID, username, price, currency, purpose, notes, status, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
if (!$stmt) {
    echo json_encode(["success" => false, "error" => "خطأ في تجهيز الاستعلام: " . $conn->error]);
    exit();
}
$stmt->bind_param("ssdsssss", $R_ID, $username, $price, $currency, $purpose, $notes, $status, $created_at);

if ($stmt->execute()) {
    echo json_encode([
        "success" => true,
        "R_ID" => $R_ID,
        "link" => $link,
        "created_at" => $created_at,
        "message" => "تم إدخال البيانات بنجاح"
    ]);
} else {
    echo json_encode(["success" => false, "error" => "خطأ أثناء تخزين البيانات: " . $stmt->error]);
}

// إغلاق الاتصال
$stmt->close();
$conn->close();
?>
